<?php

namespace App\Http\Controllers;

use App\Models\Property;
use App\Models\Customer;
use App\Models\Installment;
use App\Models\Payment;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'total_properties' => Property::count(),
            'total_customers' => Customer::count(),
            'total_revenue' => Payment::where('status', 'completed')->sum('amount'),
            'pending_installments' => Installment::where('status', 'pending')->count(),
            'overdue_installments' => Installment::where('status', 'overdue')->count(),
            'completed_payments' => Payment::where('status', 'completed')->count(),
        ];

        $recentPayments = Payment::with(['customer', 'installment.property'])
            ->where('status', 'completed')
            ->orderBy('created_at', 'desc')
            ->take(10)
            ->get();

        $upcomingInstallments = Installment::with(['customer', 'property'])
            ->where('status', 'pending')
            ->where('due_date', '>=', now())
            ->orderBy('due_date', 'asc')
            ->take(10)
            ->get();

        $overdueInstallments = Installment::with(['customer', 'property'])
            ->where('status', 'overdue')
            ->orderBy('due_date', 'asc')
            ->take(10)
            ->get();

        $monthlyRevenue = Payment::selectRaw('
                YEAR(payment_date) as year,
                MONTH(payment_date) as month,
                SUM(amount) as total
            ')
            ->where('status', 'completed')
            ->whereYear('payment_date', date('Y'))
            ->groupBy('year', 'month')
            ->orderBy('year', 'desc')
            ->orderBy('month', 'desc')
            ->get();

        return view('dashboard.index', compact(
            'stats',
            'recentPayments',
            'upcomingInstallments',
            'overdueInstallments',
            'monthlyRevenue'
        ));
    }
}
