<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Payment extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'installment_id',
        'customer_id',
        'transaction_id',
        'amount',
        'payment_date',
        'payment_method',
        'reference_number',
        'remarks',
        'status',
    ];

    protected $casts = [
        'payment_date' => 'date',
        'amount' => 'decimal:2',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($payment) {
            $payment->transaction_id = 'TRX' . time() . rand(1000, 9999);
        });

        static::created(function ($payment) {
            if ($payment->status === 'completed') {
                $installment = $payment->installment;
                $installment->paid_amount += $payment->amount;
                $installment->updateStatus();
            }
        });
    }

    public function installment()
    {
        return $this->belongsTo(Installment::class);
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
}