<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up()
{
    Schema::table('customers', function (Blueprint $table) {
        $table->string('cnic_front')->nullable()->after('cnic');
        $table->string('cnic_back')->nullable()->after('cnic_front');
        $table->string('customer_picture')->nullable()->after('cnic_back');
        $table->json('other_documents')->nullable()->after('customer_picture');
    });
}

public function down()
{
    Schema::table('customers', function (Blueprint $table) {
        $table->dropColumn(['cnic_front', 'cnic_back', 'customer_picture', 'other_documents']);
    });
}
};
