<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('customer_property', function (Blueprint $table) {
            $table->id();
            $table->foreignId('customer_id')->constrained()->onDelete('cascade');
            $table->foreignId('property_id')->constrained()->onDelete('cascade');
            $table->date('purchase_date');
            $table->decimal('total_amount', 15, 2);
            $table->decimal('down_payment', 15, 2);
            $table->decimal('installment_amount', 15, 2);
            $table->integer('total_installments');
            $table->string('payment_frequency')->default('monthly');
            $table->text('notes')->nullable();
            $table->timestamps();

            // Unique constraint to prevent duplicate relationships
            $table->unique(['customer_id', 'property_id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('customer_property');
    }
};
