@extends('layouts.app')

@section('title', 'Customers Report')
@section('page-title', 'Customers Report')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Customers Report</h5>
        <div>
            <button class="btn btn-success" onclick="exportToExcel()">
                <i class="fas fa-download me-2"></i> Export
            </button>
            <button class="btn btn-primary" onclick="window.print()">
                <i class="fas fa-print me-2"></i> Print
            </button>
        </div>
    </div>

    <div class="card-body">
        <!-- Filters -->
        <div class="row mb-4">
            <div class="col-md-3">
                <form method="GET" action="{{ route('reports.customers') }}" id="filterForm">
                    <select class="form-control" name="status" onchange="this.form.submit()">
                        <option value="all" {{ request('status') == 'all' ? 'selected' : '' }}>All Status</option>
                        <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                        <option value="blacklisted" {{ request('status') == 'blacklisted' ? 'selected' : '' }}>Blacklisted</option>
                    </select>
                </form>
            </div>
        </div>

        <!-- Summary Statistics -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body text-center">
                        <h3 class="mb-0">{{ $totalCustomers }}</h3>
                        <small>Total Customers</small>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-success text-white">
                    <div class="card-body text-center">
                        <h3 class="mb-0">{{ $activeCustomers }}</h3>
                        <small>Active Customers</small>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-info text-white">
                    <div class="card-body text-center">
                        <h3 class="mb-0">Rs. {{ number_format($totalPayments, 0) }}</h3>
                        <small>Total Payments</small>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-warning text-white">
                    <div class="card-body text-center">
                        <h3 class="mb-0">{{ $customers->where('status', 'inactive')->count() }}</h3>
                        <small>Inactive Customers</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Customers Table -->
        <div class="table-responsive">
            <table class="table table-hover" id="customersTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Customer</th>
                        <th>Contact Info</th>
                        <th>Properties</th>
                        <th>Installments</th>
                        <th>Total Payments</th>
                        <th>Avg. Payment</th>
                        <th>Status</th>
                        <th>Member Since</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($customers as $customer)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="avatar bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-2"
                                     style="width: 40px; height: 40px; font-size: 14px;">
                                    {{ substr($customer->name, 0, 1) }}
                                </div>
                                <div>
                                    <strong>{{ $customer->name }}</strong>
                                    <div class="small text-muted">CNIC: {{ $customer->cnic }}</div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div><i class="fas fa-phone me-1 text-muted"></i> {{ $customer->phone }}</div>
                            <div><i class="fas fa-envelope me-1 text-muted"></i> {{ $customer->email }}</div>
                            <div class="small text-muted">{{ Str::limit($customer->address, 30) }}</div>
                        </td>
                        <td class="text-center">
                            <span class="badge bg-info">{{ $customer->properties_count }}</span>
                        </td>
                        <td class="text-center">
                            <span class="badge bg-secondary">{{ $customer->installments_count }}</span>
                        </td>
                        <td>
                            <strong>Rs. {{ number_format($customer->payments_sum_amount ?? 0, 2) }}</strong>
                            <div class="small text-muted">{{ $customer->payments_count }} payments</div>
                        </td>
                        <td>
                            @php
                                $avgPayment = $customer->payments_count > 0 ?
                                    ($customer->payments_sum_amount ?? 0) / $customer->payments_count : 0;
                            @endphp
                            Rs. {{ number_format($avgPayment, 2) }}
                        </td>
                        <td>
                            <span class="badge bg-{{ $customer->status == 'active' ? 'success' : ($customer->status == 'inactive' ? 'warning' : 'danger') }}">
                                {{ ucfirst($customer->status) }}
                            </span>
                        </td>
                        <td>{{ $customer->created_at->format('d M Y') }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        @if($customers->isEmpty())
        <div class="text-center py-5">
            <i class="fas fa-users fa-3x text-muted mb-3"></i>
            <h5>No Customers Found</h5>
            <p class="text-muted">No customers match your search criteria.</p>
        </div>
        @endif
    </div>
</div>

@push('scripts')
<script>
    function exportToExcel() {
        const rows = [];
        const headers = ['Customer Name', 'Phone', 'Email', 'CNIC', 'Address', 'Properties Count', 'Installments Count', 'Total Payments', 'Payment Count', 'Average Payment', 'Status', 'Member Since'];

        $('#customersTable tbody tr').each(function() {
            const row = [];
            row.push($(this).find('td:nth-child(2) strong').text().trim());
            row.push($(this).find('td:nth-child(3) div:nth-child(1)').text().replace('Phone:', '').trim());
            row.push($(this).find('td:nth-child(3) div:nth-child(2)').text().replace('Email:', '').trim());
            row.push($(this).find('td:nth-child(2) .small').text().replace('CNIC:', '').trim());
            row.push($(this).find('td:nth-child(3) .small').text().trim());
            row.push($(this).find('td:nth-child(4) span').text().trim());
            row.push($(this).find('td:nth-child(5) span').text().trim());
            row.push($(this).find('td:nth-child(6) strong').text().replace('Rs.', '').trim());
            row.push($(this).find('td:nth-child(6) .small').text().replace('payments', '').trim());
            row.push($(this).find('td:nth-child(7)').text().replace('Rs.', '').trim());
            row.push($(this).find('td:nth-child(8) span').text().trim());
            row.push($(this).find('td:nth-child(9)').text().trim());

            rows.push(row.join(','));
        });

        const csvContent = [headers.join(','), ...rows].join('\n');
        const blob = new Blob([csvContent], { type: 'text/csv' });
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = `customers_report_${new Date().toISOString().split('T')[0]}.csv`;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }
</script>
@endpush
@endsection
