<?php $__env->startSection('title', 'Payment Details'); ?>
<?php $__env->startSection('page-title', 'Payment Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <!-- Payment Details -->
    <div class="col-md-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Payment Information</h5>
                <div class="dropdown">
                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button"
                            data-bs-toggle="dropdown">
                        <i class="fas fa-cog"></i>
                    </button>
                    <ul class="dropdown-menu">
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('payments.edit', $payment)); ?>">
                                <i class="fas fa-edit me-2"></i> Edit Payment
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('payments.create')); ?>">
                                <i class="fas fa-plus me-2"></i> Record New Payment
                            </a>
                        </li>
                        <?php if($payment->status != 'refunded'): ?>
                        <li>
                            <button type="button" class="dropdown-item text-danger"
                                    onclick="confirmRefund()">
                                <i class="fas fa-undo me-2"></i> Mark as Refunded
                            </button>
                        </li>
                        <?php endif; ?>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <form action="<?php echo e(route('payments.destroy', $payment)); ?>" method="POST"
                                  class="dropdown-item p-0">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-link text-danger p-0"
                                        onclick="return confirm('Delete this payment record? This will affect installment status.')">
                                    <i class="fas fa-trash me-2"></i> Delete
                                </button>
                            </form>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="card-body">
                <div class="text-center mb-4">
                    <div class="payment-icon mb-3">
                        <?php
                            $methodIcons = [
                                'cash' => 'money-bill-wave',
                                'bank_transfer' => 'university',
                                'cheque' => 'file-invoice-dollar',
                                'online' => 'globe'
                            ];
                            $statusColors = [
                                'completed' => 'success',
                                'pending' => 'warning',
                                'failed' => 'danger',
                                'refunded' => 'info'
                            ];
                        ?>
                        <div class="avatar bg-<?php echo e($statusColors[$payment->status]); ?> text-white rounded-circle d-flex align-items-center justify-content-center mx-auto"
                             style="width: 80px; height: 80px; font-size: 32px;">
                            <i class="fas fa-<?php echo e($methodIcons[$payment->payment_method] ?? 'credit-card'); ?>"></i>
                        </div>
                    </div>

                    <h4 class="mt-2">Payment Receipt</h4>
                    <p class="text-muted">
                        <span class="badge bg-<?php echo e($statusColors[$payment->status]); ?> p-2 fs-6">
                            <?php echo e(ucfirst($payment->status)); ?>

                        </span>
                    </p>

                    <div class="receipt-amount mt-4">
                        <h1 class="text-success">Rs. <?php echo e(number_format($payment->amount, 2)); ?></h1>
                        <p class="text-muted mb-0">Payment Amount</p>
                    </div>
                </div>

                <!-- Transaction Details -->
                <div class="mb-4">
                    <h6 class="border-bottom pb-2">
                        <i class="fas fa-receipt me-2 text-primary"></i>Transaction Details
                    </h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless">
                            <tr>
                                <td width="40%"><strong>Transaction ID:</strong></td>
                                <td><code><?php echo e($payment->transaction_id); ?></code></td>
                            </tr>
                            <tr>
                                <td><strong>Payment Date:</strong></td>
                                <td><?php echo e($payment->payment_date->format('d M Y')); ?></td>
                            </tr>
                            <tr>
                                <td><strong>Recorded On:</strong></td>
                                <td><?php echo e($payment->created_at->format('d M Y, h:i A')); ?></td>
                            </tr>
                            <tr>
                                <td><strong>Payment Method:</strong></td>
                                <td>
                                    <span class="badge bg-primary">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $payment->payment_method))); ?>

                                    </span>
                                </td>
                            </tr>
                            <?php if($payment->reference_number): ?>
                            <tr>
                                <td><strong>Reference Number:</strong></td>
                                <td><code><?php echo e($payment->reference_number); ?></code></td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <td><strong>Last Updated:</strong></td>
                                <td><?php echo e($payment->updated_at->format('d M Y, h:i A')); ?></td>
                            </tr>
                        </table>
                    </div>
                </div>

                <!-- Customer Information -->
                <div class="mb-4">
                    <h6 class="border-bottom pb-2">
                        <i class="fas fa-user me-2 text-info"></i>Customer Information
                    </h6>
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="avatar bg-info text-white rounded-circle d-flex align-items-center justify-content-center me-3"
                                 style="width: 50px; height: 50px; font-size: 18px;">
                                <?php echo e(substr($payment->customer->name, 0, 1)); ?>

                            </div>
                        </div>
                        <div class="flex-grow-1">
                            <h6 class="mb-0"><?php echo e($payment->customer->name); ?></h6>
                            <p class="small text-muted mb-1">
                                <i class="fas fa-phone"></i> <?php echo e($payment->customer->phone); ?>

                            </p>
                            <p class="small text-muted mb-0">
                                <i class="fas fa-envelope"></i> <?php echo e($payment->customer->email); ?>

                            </p>
                        </div>
                        <div class="flex-shrink-0">
                            <a href="<?php echo e(route('customers.show', $payment->customer)); ?>"
                               class="btn btn-sm btn-outline-info">
                                <i class="fas fa-external-link-alt"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Installment Information -->
                <div class="mb-4">
                    <h6 class="border-bottom pb-2">
                        <i class="fas fa-file-invoice-dollar me-2 text-success"></i>Installment Information
                    </h6>
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="avatar bg-success text-white rounded-circle d-flex align-items-center justify-content-center me-3"
                                 style="width: 50px; height: 50px; font-size: 18px;">
                                #
                            </div>
                        </div>
                        <div class="flex-grow-1">
                            <h6 class="mb-0">Installment #<?php echo e($payment->installment->installment_number); ?></h6>
                            <p class="small text-muted mb-1">
                                <i class="fas fa-building"></i> <?php echo e($payment->installment->property->name); ?>

                            </p>
                            <p class="small text-muted mb-0">
                                <i class="fas fa-calendar"></i> Due: <?php echo e($payment->installment->due_date->format('d M Y')); ?>

                            </p>
                        </div>
                        <div class="flex-shrink-0">
                            <a href="<?php echo e(route('installments.show', $payment->installment)); ?>"
                               class="btn btn-sm btn-outline-success">
                                <i class="fas fa-external-link-alt"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <?php if($payment->remarks): ?>
                <!-- Remarks -->
                <div class="mb-4">
                    <h6 class="border-bottom pb-2">
                        <i class="fas fa-sticky-note me-2 text-secondary"></i>Remarks
                    </h6>
                    <div class="alert alert-light">
                        <p class="mb-0"><?php echo e($payment->remarks); ?></p>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Quick Actions -->
                <div class="mt-4">
                    <div class="d-grid gap-2">
                        <button type="button" class="btn btn-primary" onclick="printReceipt()">
                            <i class="fas fa-print me-2"></i> Print Receipt
                        </button>
                        <?php if($payment->status != 'refunded'): ?>
                            <button type="button" class="btn btn-danger" onclick="confirmRefund()">
                                <i class="fas fa-undo me-2"></i> Mark as Refunded
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Payment History & Related Info -->
    <div class="col-md-8">
        <!-- Customer Payment History -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Customer's Recent Payments</h5>
                <a href="<?php echo e(route('payments.create', ['customer_id' => $payment->customer->id])); ?>"
                   class="btn btn-primary btn-sm">
                    <i class="fas fa-plus me-1"></i> New Payment
                </a>
            </div>
            <div class="card-body">
                <?php
                    $recentPayments = $payment->customer->payments()
                        ->where('id', '!=', $payment->id)
                        ->with(['installment.property'])
                        ->orderBy('payment_date', 'desc')
                        ->take(5)
                        ->get();
                ?>

                <?php if($recentPayments->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Transaction ID</th>
                                <th>Property</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $recentPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recentPayment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="<?php echo e($recentPayment->id == $payment->id ? 'table-active' : ''); ?>">
                                <td><?php echo e($recentPayment->payment_date->format('d/m/Y')); ?></td>
                                <td>
                                    <code><?php echo e($recentPayment->transaction_id); ?></code>
                                </td>
                                <td><?php echo e($recentPayment->installment->property->name); ?></td>
                                <td>Rs. <?php echo e(number_format($recentPayment->amount, 2)); ?></td>
                                <td>
                                    <?php
                                        $recentStatusColors = [
                                            'completed' => 'success',
                                            'pending' => 'warning',
                                            'failed' => 'danger',
                                            'refunded' => 'info'
                                        ];
                                    ?>
                                    <span class="badge bg-<?php echo e($recentStatusColors[$recentPayment->status] ?? 'secondary'); ?>">
                                        <?php echo e(ucfirst($recentPayment->status)); ?>

                                    </span>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('payments.show', $recentPayment)); ?>"
                                       class="btn btn-sm btn-outline-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                <div class="text-center py-3">
                    <p class="text-muted mb-0">No other payments recorded for this customer.</p>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Installment Payment History -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">Installment Payment History</h5>
            </div>
            <div class="card-body">
                <?php
                    $installmentPayments = $payment->installment->payments()
                        ->orderBy('payment_date', 'desc')
                        ->get();
                ?>

                <?php if($installmentPayments->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Date</th>
                                <th>Transaction ID</th>
                                <th>Amount</th>
                                <th>Method</th>
                                <th>Status</th>
                                <th>Remarks</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $installmentPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $installmentPayment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="<?php echo e($installmentPayment->id == $payment->id ? 'table-active' : ''); ?>">
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($installmentPayment->payment_date->format('d/m/Y')); ?></td>
                                <td>
                                    <code><?php echo e($installmentPayment->transaction_id); ?></code>
                                </td>
                                <td>Rs. <?php echo e(number_format($installmentPayment->amount, 2)); ?></td>
                                <td>
                                    <span class="badge bg-primary">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $installmentPayment->payment_method))); ?>

                                    </span>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($recentStatusColors[$installmentPayment->status] ?? 'secondary'); ?>">
                                        <?php echo e(ucfirst($installmentPayment->status)); ?>

                                    </span>
                                </td>
                                <td><?php echo e(Str::limit($installmentPayment->remarks, 30)); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot>
                            <tr class="table-success">
                                <td colspan="3" class="text-end"><strong>Total Paid:</strong></td>
                                <td colspan="4">
                                    <strong>Rs. <?php echo e(number_format($installmentPayments->where('status', 'completed')->sum('amount'), 2)); ?></strong>
                                </td>
                            </tr>
                            <tr class="table-warning">
                                <td colspan="3" class="text-end"><strong>Remaining:</strong></td>
                                <td colspan="4">
                                    <strong>Rs. <?php echo e(number_format($payment->installment->remaining_amount, 2)); ?></strong>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                <?php endif; ?>

                <!-- Installment Progress -->
                <div class="mt-4">
                    <div class="d-flex justify-content-between mb-2">
                        <small class="text-muted">Installment Progress</small>
                        <small class="text-muted">
                            <?php echo e(round(($payment->installment->paid_amount / $payment->installment->amount) * 100)); ?>%
                        </small>
                    </div>
                    <div class="progress" style="height: 15px;">
                        <div class="progress-bar bg-success" role="progressbar"
                             style="width: <?php echo e(($payment->installment->paid_amount / $payment->installment->amount) * 100); ?>%;">
                        </div>
                    </div>
                    <div class="d-flex justify-content-between mt-1">
                        <small class="text-muted">
                            Paid: Rs. <?php echo e(number_format($payment->installment->paid_amount, 2)); ?>

                        </small>
                        <small class="text-muted">
                            Total: Rs. <?php echo e(number_format($payment->installment->amount, 2)); ?>

                        </small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Payment Timeline -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">Payment Timeline</h5>
            </div>
            <div class="card-body">
                <div class="timeline">
                    <!-- Timeline Item 1: Installment Created -->
                    <div class="timeline-item">
                        <div class="timeline-marker bg-primary">
                            <i class="fas fa-calendar-plus text-white"></i>
                        </div>
                        <div class="timeline-content">
                            <div class="timeline-title">Installment Created</div>
                            <div class="timeline-date"><?php echo e($payment->installment->created_at->format('d M Y')); ?></div>
                            <div class="timeline-description">Installment schedule was created</div>
                        </div>
                    </div>

                    <!-- Timeline Item 2: Installment Due Date -->
                    <div class="timeline-item">
                        <div class="timeline-marker bg-<?php echo e($payment->installment->isOverdue() ? 'danger' : 'info'); ?>">
                            <i class="fas fa-calendar-check text-white"></i>
                        </div>
                        <div class="timeline-content">
                            <div class="timeline-title">Installment Due Date</div>
                            <div class="timeline-date"><?php echo e($payment->installment->due_date->format('d M Y')); ?></div>
                            <div class="timeline-description">
                                Original due date
                                <?php if($payment->installment->isOverdue()): ?>
                                    <span class="badge bg-danger ms-2">Overdue</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Timeline Item 3: Payment Recorded -->
                    <div class="timeline-item">
                        <div class="timeline-marker bg-success">
                            <i class="fas fa-money-check-alt text-white"></i>
                        </div>
                        <div class="timeline-content">
                            <div class="timeline-title">Payment Recorded</div>
                            <div class="timeline-date"><?php echo e($payment->payment_date->format('d M Y')); ?></div>
                            <div class="timeline-description">
                                Rs. <?php echo e(number_format($payment->amount, 2)); ?> payment recorded
                                <br>
                                <small class="text-muted">Transaction: <?php echo e($payment->transaction_id); ?></small>
                            </div>
                        </div>
                    </div>

                    <!-- Timeline Item 4: Last Update -->
                    <div class="timeline-item">
                        <div class="timeline-marker bg-secondary">
                            <i class="fas fa-sync-alt text-white"></i>
                        </div>
                        <div class="timeline-content">
                            <div class="timeline-title">Last Updated</div>
                            <div class="timeline-date"><?php echo e($payment->updated_at->format('d M Y, h:i A')); ?></div>
                            <div class="timeline-description">
                                Status: <span class="badge bg-<?php echo e($statusColors[$payment->status]); ?>">
                                    <?php echo e(ucfirst($payment->status)); ?>

                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Timeline Item 5: Installment Status (if paid) -->
                    <?php if($payment->installment->status == 'paid'): ?>
                    <div class="timeline-item">
                        <div class="timeline-marker bg-success">
                            <i class="fas fa-check-circle text-white"></i>
                        </div>
                        <div class="timeline-content">
                            <div class="timeline-title">Installment Completed</div>
                            <div class="timeline-date"><?php echo e($payment->installment->updated_at->format('d M Y')); ?></div>
                            <div class="timeline-description">Installment fully paid</div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Quick Stats -->
        <div class="row mt-4">
            <div class="col-md-4">
                <div class="card bg-primary text-white">
                    <div class="card-body text-center py-3">
                        <h4 class="mb-0"><?php echo e($payment->customer->payments->count()); ?></h4>
                        <small>Total Payments by Customer</small>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card bg-success text-white">
                    <div class="card-body text-center py-3">
                        <h4 class="mb-0">Rs. <?php echo e(number_format($payment->customer->payments->sum('amount'), 0)); ?></h4>
                        <small>Total Paid by Customer</small>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card bg-info text-white">
                    <div class="card-body text-center py-3">
                        <h4 class="mb-0"><?php echo e($payment->installment->property->installments->count()); ?></h4>
                        <small>Total Installments in Property</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Print Receipt (Hidden) -->
<div id="receiptPrint" class="d-none">
    <div class="container p-5">
        <div class="text-center mb-4">
            <h2>Payment Receipt</h2>
            <h4>Transaction: <?php echo e($payment->transaction_id); ?></h4>
            <p>Generated on: <?php echo e(now()->format('d M Y, h:i A')); ?></p>
        </div>

        <div class="row mb-4">
            <div class="col-md-6">
                <h5>Payment Information</h5>
                <p><strong>Transaction ID:</strong> <?php echo e($payment->transaction_id); ?></p>
                <p><strong>Date:</strong> <?php echo e($payment->payment_date->format('d M Y')); ?></p>
                <p><strong>Amount:</strong> Rs. <?php echo e(number_format($payment->amount, 2)); ?></p>
                <p><strong>Method:</strong> <?php echo e(ucfirst(str_replace('_', ' ', $payment->payment_method))); ?></p>
                <p><strong>Status:</strong> <?php echo e(ucfirst($payment->status)); ?></p>
                <?php if($payment->reference_number): ?>
                    <p><strong>Reference:</strong> <?php echo e($payment->reference_number); ?></p>
                <?php endif; ?>
            </div>
            <div class="col-md-6">
                <h5>Customer Information</h5>
                <p><strong>Name:</strong> <?php echo e($payment->customer->name); ?></p>
                <p><strong>Phone:</strong> <?php echo e($payment->customer->phone); ?></p>
                <p><strong>Email:</strong> <?php echo e($payment->customer->email); ?></p>
                <p><strong>CNIC:</strong> <?php echo e($payment->customer->cnic); ?></p>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-md-6">
                <h5>Property Information</h5>
                <p><strong>Property:</strong> <?php echo e($payment->installment->property->name); ?></p>
                <p><strong>Location:</strong> <?php echo e($payment->installment->property->location); ?></p>
                <p><strong>Total Price:</strong> Rs. <?php echo e(number_format($payment->installment->property->total_price, 2)); ?></p>
            </div>
            <div class="col-md-6">
                <h5>Installment Details</h5>
                <p><strong>Installment #:</strong> <?php echo e($payment->installment->installment_number); ?></p>
                <p><strong>Due Date:</strong> <?php echo e($payment->installment->due_date->format('d M Y')); ?></p>
                <p><strong>Installment Amount:</strong> Rs. <?php echo e(number_format($payment->installment->amount, 2)); ?></p>
                <p><strong>Total Paid:</strong> Rs. <?php echo e(number_format($payment->installment->paid_amount, 2)); ?></p>
                <p><strong>Remaining:</strong> Rs. <?php echo e(number_format($payment->installment->remaining_amount, 2)); ?></p>
            </div>
        </div>

        <?php if($payment->remarks): ?>
        <div class="mb-4">
            <h5>Remarks</h5>
            <p><?php echo e($payment->remarks); ?></p>
        </div>
        <?php endif; ?>

        <hr>
        <div class="text-center mt-4">
            <p>This is an official payment receipt. Please keep it for your records.</p>
            <p>For any queries, contact: <?php echo e(config('app.name')); ?> - <?php echo e(config('app.url')); ?></p>
        </div>
    </div>
</div>

<!-- Refund Modal -->
<div class="modal fade" id="refundModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Mark Payment as Refunded</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="refundForm" method="POST" action="<?php echo e(route('payments.update', $payment)); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <input type="hidden" name="status" value="refunded">

                    <div class="mb-3">
                        <label for="refund_date" class="form-label">Refund Date</label>
                        <input type="date" class="form-control" id="refund_date" name="payment_date"
                               value="<?php echo e(date('Y-m-d')); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label for="refund_reason" class="form-label">Refund Reason</label>
                        <textarea class="form-control" id="refund_reason" name="remarks"
                                  rows="3" placeholder="Enter reason for refund" required></textarea>
                    </div>

                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>Warning:</strong> This will reduce the paid amount in the installment and may change its status.
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="submit" form="refundForm" class="btn btn-danger">Confirm Refund</button>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    // Print receipt
    function printReceipt() {
        const printContent = document.getElementById('receiptPrint').innerHTML;
        const originalContent = document.body.innerHTML;

        document.body.innerHTML = printContent;
        window.print();
        document.body.innerHTML = originalContent;
        window.location.reload();
    }

    // Confirm refund
    function confirmRefund() {
        new bootstrap.Modal(document.getElementById('refundModal')).show();
    }

    // Initialize tooltips
    $(document).ready(function() {
        $('[data-bs-toggle="tooltip"]').tooltip();
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .avatar {
        font-weight: bold;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .badge {
        min-width: 80px;
        text-align: center;
        padding: 8px 12px;
    }

    .receipt-amount h1 {
        font-weight: 800;
        color: #28a745 !important;
    }

    .timeline {
        position: relative;
        padding-left: 40px;
    }

    .timeline::before {
        content: '';
        position: absolute;
        left: 20px;
        top: 0;
        bottom: 0;
        width: 2px;
        background: linear-gradient(to bottom, #dee2e6, #6c757d);
    }

    .timeline-item {
        position: relative;
        margin-bottom: 20px;
    }

    .timeline-marker {
        position: absolute;
        left: -40px;
        top: 0;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        border: 3px solid white;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }

    .timeline-content {
        padding-left: 20px;
    }

    .timeline-title {
        font-weight: 600;
        color: #495057;
        margin-bottom: 5px;
    }

    .timeline-date {
        font-size: 12px;
        color: #6c757d;
        margin-bottom: 5px;
    }

    .timeline-description {
        font-size: 14px;
        color: #495057;
    }

    .table-borderless td {
        border: none !important;
    }

    .table-active {
        background-color: rgba(67, 97, 238, 0.1) !important;
    }

    @media print {
        .no-print {
            display: none !important;
        }

        body {
            background: white !important;
            color: black !important;
            font-size: 12px !important;
        }

        .container {
            max-width: 100% !important;
        }
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\property-system\resources\views/payments/show.blade.php ENDPATH**/ ?>