<?php $__env->startSection('title', $customer->name . ' - Customer Profile'); ?>
<?php $__env->startSection('page-title', 'Customer Profile'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Customer Header -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="d-flex align-items-center">
                            <?php if($customer->customer_picture): ?>
                                <img src="<?php echo e(asset('storage/' . $customer->customer_picture)); ?>"
                                     alt="Customer Picture" class="rounded-circle me-3"
                                     width="80" height="80" style="object-fit: cover;">
                            <?php else: ?>
                                <div class="bg-light rounded-circle d-flex align-items-center justify-content-center me-3"
                                     style="width: 80px; height: 80px;">
                                    <span class="h4 mb-0 text-muted"><?php echo e($customer->initials); ?></span>
                                </div>
                            <?php endif; ?>
                            <div>
                                <h4 class="mb-1"><?php echo e($customer->name); ?></h4>
                                <p class="text-muted mb-1">
                                    <i class="fas fa-id-card me-1"></i> <?php echo e($customer->cnic); ?>

                                </p>
                                <span class="badge bg-<?php echo e($customer->status == 'active' ? 'success' : ($customer->status == 'inactive' ? 'warning' : 'danger')); ?>">
                                    <?php echo e(ucfirst($customer->status)); ?>

                                </span>
                            </div>
                        </div>
                        <div>
                            <a href="<?php echo e(route('customers.edit', $customer->id)); ?>" class="btn btn-primary me-2">
                                <i class="fas fa-edit me-1"></i> Edit Profile
                            </a>
                            <a href="<?php echo e(route('customers.download-all', $customer->id)); ?>" class="btn btn-success me-2">
                                <i class="fas fa-download me-1"></i> Download All
                            </a>
                            <div class="btn-group">
                                <button type="button" class="btn btn-secondary dropdown-toggle" data-bs-toggle="dropdown">
                                    <i class="fas fa-ellipsis-v"></i>
                                </button>
                                <ul class="dropdown-menu">
                                    <li>
                                        <a class="dropdown-item" href="#" onclick="window.print()">
                                            <i class="fas fa-print me-2"></i> Print Profile
                                        </a>
                                    </li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li>
                                        <form action="<?php echo e(route('customers.destroy', $customer->id)); ?>" method="POST"
                                              id="deleteForm" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="button" class="dropdown-item text-danger"
                                                    onclick="confirmDelete()">
                                                <i class="fas fa-trash me-2"></i> Delete Customer
                                            </button>
                                        </form>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Left Column: Customer Info & Documents -->
        <div class="col-md-4">
            <!-- Customer Information -->
            <div class="card mb-4">
                <div class="card-header bg-info text-white">
                    <h6 class="mb-0"><i class="fas fa-info-circle me-2"></i> Personal Information</h6>
                </div>
                <div class="card-body">
                    <table class="table table-borderless">
                        <tr>
                            <th width="40%">Email:</th>
                            <td>
                                <?php if($customer->email): ?>
                                    <a href="mailto:<?php echo e($customer->email); ?>"><?php echo e($customer->email); ?></a>
                                <?php else: ?>
                                    <span class="text-muted">Not provided</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>Phone:</th>
                            <td>
                                <a href="tel:+92<?php echo e($customer->phone); ?>">+92 <?php echo e($customer->phone); ?></a>
                            </td>
                        </tr>
                        <tr>
                            <th>Date of Birth:</th>
                            <td>
                                <?php if($customer->date_of_birth): ?>
                                    <?php echo e($customer->date_of_birth->format('d M, Y')); ?>

                                    <small class="text-muted">(<?php echo e($customer->age); ?> years)</small>
                                <?php else: ?>
                                    <span class="text-muted">Not provided</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>Address:</th>
                            <td><?php echo e($customer->address); ?></td>
                        </tr>
                        <tr>
                            <th>Created:</th>
                            <td><?php echo e($customer->created_at->format('d M, Y h:i A')); ?></td>
                        </tr>
                        <tr>
                            <th>Last Updated:</th>
                            <td><?php echo e($customer->updated_at->format('d M, Y h:i A')); ?></td>
                        </tr>
                    </table>
                </div>
            </div>

            <!-- Documents Gallery -->
            <div class="card">
                <div class="card-header bg-success text-white">
                    <h6 class="mb-0"><i class="fas fa-file-alt me-2"></i> Customer Documents</h6>
                </div>
                <div class="card-body">
                    <!-- Document Completion -->
                    <div class="mb-4">
                        <div class="d-flex justify-content-between mb-1">
                            <span>Document Completion</span>
                            <span><?php echo e(number_format($customer->document_completion, 0)); ?>%</span>
                        </div>
                        <div class="progress" style="height: 8px;">
                            <div class="progress-bar bg-success" style="width: <?php echo e($customer->document_completion); ?>%"></div>
                        </div>
                        <small class="text-muted"><?php echo e($customer->total_documents); ?> documents uploaded</small>
                    </div>

                    <div class="row">
                        <!-- CNIC Front -->
                        <div class="col-6 mb-3">
                            <div class="card document-card h-100">
                                <div class="card-body text-center">
                                    <h6>CNIC Front</h6>
                                    <?php if($customer->cnic_front): ?>
                                        <a href="<?php echo e(route('customers.download-document', [$customer->id, 'cnic_front'])); ?>"
                                           class="d-block mb-2">
                                            <img src="<?php echo e(asset('storage/' . $customer->cnic_front)); ?>"
                                                 alt="CNIC Front" class="img-thumbnail">
                                        </a>
                                        <div class="btn-group btn-group-sm">
                                            <a href="<?php echo e(asset('storage/' . $customer->cnic_front)); ?>"
                                               target="_blank" class="btn btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('customers.download-document', [$customer->id, 'cnic_front'])); ?>"
                                               class="btn btn-success">
                                                <i class="fas fa-download"></i>
                                            </a>
                                            <form action="<?php echo e(route('customers.delete-document', $customer->id)); ?>"
                                                  method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <input type="hidden" name="document_type" value="cnic_front">
                                                <button type="submit" class="btn btn-danger"
                                                        onclick="return confirm('Delete CNIC front image?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    <?php else: ?>
                                        <div class="text-muted py-4">Not uploaded</div>
                                        <small class="text-muted">Upload from Edit page</small>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- CNIC Back -->
                        <div class="col-6 mb-3">
                            <div class="card document-card h-100">
                                <div class="card-body text-center">
                                    <h6>CNIC Back</h6>
                                    <?php if($customer->cnic_back): ?>
                                        <a href="<?php echo e(route('customers.download-document', [$customer->id, 'cnic_back'])); ?>"
                                           class="d-block mb-2">
                                            <img src="<?php echo e(asset('storage/' . $customer->cnic_back)); ?>"
                                                 alt="CNIC Back" class="img-thumbnail">
                                        </a>
                                        <div class="btn-group btn-group-sm">
                                            <a href="<?php echo e(asset('storage/' . $customer->cnic_back)); ?>"
                                               target="_blank" class="btn btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('customers.download-document', [$customer->id, 'cnic_back'])); ?>"
                                               class="btn btn-success">
                                                <i class="fas fa-download"></i>
                                            </a>
                                            <form action="<?php echo e(route('customers.delete-document', $customer->id)); ?>"
                                                  method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <input type="hidden" name="document_type" value="cnic_back">
                                                <button type="submit" class="btn btn-danger"
                                                        onclick="return confirm('Delete CNIC back image?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    <?php else: ?>
                                        <div class="text-muted py-4">Not uploaded</div>
                                        <small class="text-muted">Upload from Edit page</small>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Customer Picture -->
                        <div class="col-12 mb-3">
                            <div class="card document-card">
                                <div class="card-body text-center">
                                    <h6>Customer Picture</h6>
                                    <?php if($customer->customer_picture): ?>
                                        <a href="<?php echo e(route('customers.download-document', [$customer->id, 'customer_picture'])); ?>"
                                           class="d-block mb-2">
                                            <img src="<?php echo e(asset('storage/' . $customer->customer_picture)); ?>"
                                                 alt="Customer Picture" class="img-thumbnail rounded-circle"
                                                 width="150" height="150" style="object-fit: cover;">
                                        </a>
                                        <div class="btn-group btn-group-sm">
                                            <a href="<?php echo e(asset('storage/' . $customer->customer_picture)); ?>"
                                               target="_blank" class="btn btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('customers.download-document', [$customer->id, 'customer_picture'])); ?>"
                                               class="btn btn-success">
                                                <i class="fas fa-download"></i>
                                            </a>
                                            <form action="<?php echo e(route('customers.delete-document', $customer->id)); ?>"
                                                  method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <input type="hidden" name="document_type" value="customer_picture">
                                                <button type="submit" class="btn btn-danger"
                                                        onclick="return confirm('Delete customer picture?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    <?php else: ?>
                                        <div class="text-muted py-4">Not uploaded</div>
                                        <small class="text-muted">Upload from Edit page</small>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Other Documents -->
                        <div class="col-12">
                            <div class="card document-card">
                                <div class="card-body">
                                    <h6 class="text-center mb-3">Other Documents</h6>
                                    <?php if(!empty($customer->other_documents)): ?>
                                        <div class="list-group list-group-flush">
                                            <?php $__currentLoopData = $customer->other_documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div class="d-flex align-items-center">
                                                        <?php
                                                            $extension = pathinfo($document, PATHINFO_EXTENSION);
                                                            $icon = 'fa-file';
                                                            if (in_array($extension, ['pdf'])) $icon = 'fa-file-pdf text-danger';
                                                            elseif (in_array($extension, ['doc', 'docx'])) $icon = 'fa-file-word text-primary';
                                                            elseif (in_array($extension, ['jpg', 'jpeg', 'png', 'gif'])) $icon = 'fa-file-image text-success';
                                                        ?>
                                                        <i class="fas <?php echo e($icon); ?> me-2"></i>
                                                        <span class="text-truncate" style="max-width: 150px;">
                                                            Document <?php echo e($index + 1); ?>.<?php echo e($extension); ?>

                                                        </span>
                                                    </div>
                                                    <div class="btn-group btn-group-sm">
                                                        <a href="<?php echo e(asset('storage/' . $document)); ?>"
                                                           target="_blank" class="btn btn-info">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                        <a href="<?php echo e(route('customers.download-document', [$customer->id, 'other_documents', $index])); ?>"
                                                           class="btn btn-success">
                                                            <i class="fas fa-download"></i>
                                                        </a>
                                                        <form action="<?php echo e(route('customers.delete-document', $customer->id)); ?>"
                                                              method="POST" class="d-inline">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('DELETE'); ?>
                                                            <input type="hidden" name="document_type" value="other_documents">
                                                            <input type="hidden" name="document_index" value="<?php echo e($index); ?>">
                                                            <button type="submit" class="btn btn-danger"
                                                                    onclick="return confirm('Delete this document?')">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php else: ?>
                                        <div class="text-center text-muted py-3">No other documents uploaded</div>
                                        <small class="text-muted d-block text-center">Upload from Edit page</small>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Column: Financial Information -->
        <div class="col-md-8">
            <!-- Financial Summary -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body text-center">
                            <h6 class="card-title">Total Installments</h6>
                            <h4 class="mb-0"><?php echo e($customer->installments_count); ?></h4>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body text-center">
                            <h6 class="card-title">Total Paid</h6>
                            <h4 class="mb-0">Rs. <?php echo e(number_format($customer->total_paid, 0)); ?></h4>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body text-center">
                            <h6 class="card-title">Total Pending</h6>
                            <h4 class="mb-0">Rs. <?php echo e(number_format($customer->total_pending, 0)); ?></h4>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-info text-white">
                        <div class="card-body text-center">
                            <h6 class="card-title">Properties</h6>
                            <h4 class="mb-0"><?php echo e($properties->count()); ?></h4>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Properties -->
            <div class="card mb-4">
                <div class="card-header bg-secondary text-white">
                    <h6 class="mb-0"><i class="fas fa-building me-2"></i> Associated Properties</h6>
                </div>
                <div class="card-body">
                    <?php if($properties->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Property</th>
                                        <th>Total Installments</th>
                                        <th>Paid</th>
                                        <th>Pending</th>
                                        <th>Progress</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $paid_installments = $property->installments()->where('status', 'paid')->count();
                                            $total_installments = $property->installments()->count();
                                            $progress = $total_installments > 0 ? ($paid_installments / $total_installments) * 100 : 0;
                                        ?>
                                        <tr>
                                            <td><?php echo e($property->name); ?></td>
                                            <td><?php echo e($total_installments); ?></td>
                                            <td><?php echo e($paid_installments); ?></td>
                                            <td><?php echo e($total_installments - $paid_installments); ?></td>
                                            <td>
                                                <div class="progress" style="height: 8px;">
                                                    <div class="progress-bar bg-success" style="width: <?php echo e($progress); ?>%"></div>
                                                </div>
                                                <small class="text-muted"><?php echo e(number_format($progress, 1)); ?>%</small>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('properties.show', $property->id)); ?>" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-4">
                            <i class="fas fa-building fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No properties assigned to this customer</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Recent Payments -->
            <div class="card">
                <div class="card-header bg-dark text-white">
                    <h6 class="mb-0"><i class="fas fa-exchange-alt me-2"></i> Recent Payments</h6>
                </div>
                <div class="card-body">
                    <?php if($customer->payments->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Property</th>
                                        <th>Amount</th>
                                        <th>Method</th>
                                        <th>Status</th>
                                        <th>Receipt</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $customer->payments->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($payment->created_at->format('d M, Y')); ?></td>
                                            <td><?php echo e($payment->installment->property->name ?? 'N/A'); ?></td>
                                            <td>Rs. <?php echo e(number_format($payment->amount, 0)); ?></td>
                                            <td>
                                                <span class="badge bg-info"><?php echo e(ucfirst($payment->payment_method ?? 'N/A')); ?></span>
                                            </td>
                                            <td>
                                                <span class="badge bg-<?php echo e($payment->status == 'completed' ? 'success' : ($payment->status == 'pending' ? 'warning' : 'danger')); ?>">
                                                    <?php echo e(ucfirst($payment->status)); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <?php if($payment->receipt_path): ?>
                                                    <a href="<?php echo e(asset('storage/' . $payment->receipt_path)); ?>"
                                                       target="_blank" class="btn btn-sm btn-outline-success">
                                                        <i class="fas fa-receipt"></i>
                                                    </a>
                                                <?php else: ?>
                                                    <span class="text-muted">No receipt</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="text-center mt-3">
                            <a href="#" class="btn btn-outline-primary">View All Transactions</a>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-4">
                            <i class="fas fa-exchange-alt fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No payment history found</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    function confirmDelete() {
        if (confirm('Are you sure you want to delete this customer? This will also delete all associated documents and cannot be undone.')) {
            document.getElementById('deleteForm').submit();
        }
    }
</script>
<style>
    .document-card {
        transition: transform 0.2s;
        border: 1px solid #e9ecef;
    }
    .document-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }
    .document-card img {
        max-height: 150px;
        object-fit: contain;
    }
    .progress {
        background-color: #e9ecef;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\property-system\resources\views/customers/show.blade.php ENDPATH**/ ?>