<?php $__env->startSection('title', 'Add New Property'); ?>
<?php $__env->startSection('page-title', 'Add New Property'); ?>

<?php $__env->startSection('content'); ?>
<div class="row justify-content-center">
    <div class="col-md-10">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Property Information</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="<?php echo e(route('properties.store')); ?>" id="propertyForm">
                    <?php echo csrf_field(); ?>

                    <div class="row">
                        <!-- Property Details -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="name" class="form-label">Property Name *</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       id="name" name="name" value="<?php echo e(old('name')); ?>"
                                       placeholder="Enter property name" required>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="mb-3">
                                <label for="location" class="form-label">Location *</label>
                                <textarea class="form-control <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                          id="location" name="location" rows="2"
                                          placeholder="Enter property address" required><?php echo e(old('location')); ?></textarea>
                                <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="mb-3">
                                <label for="total_price" class="form-label">Total Price (PKR) *</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rs.</span>
                                    <input type="number" step="0.01" class="form-control <?php $__errorArgs = ['total_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           id="total_price" name="total_price" value="<?php echo e(old('total_price')); ?>"
                                           placeholder="Enter total price" required min="0">
                                </div>
                                <?php $__errorArgs = ['total_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="mb-3">
                                <label for="down_payment" class="form-label">Down Payment (PKR) *</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rs.</span>
                                    <input type="number" step="0.01" class="form-control <?php $__errorArgs = ['down_payment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           id="down_payment" name="down_payment" value="<?php echo e(old('down_payment')); ?>"
                                           placeholder="Enter down payment" required min="0">
                                </div>
                                <?php $__errorArgs = ['down_payment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Installment Details -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="installment_years" class="form-label">Installment Period (Years) *</label>
                                <select class="form-control <?php $__errorArgs = ['installment_years'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="installment_years" name="installment_years" required>
                                    <option value="">Select years</option>
                                    <?php for($i = 1; $i <= 30; $i++): ?>
                                        <option value="<?php echo e($i); ?>" <?php echo e(old('installment_years') == $i ? 'selected' : ''); ?>>
                                            <?php echo e($i); ?> <?php echo e(Str::plural('year', $i)); ?>

                                        </option>
                                    <?php endfor; ?>
                                </select>
                                <?php $__errorArgs = ['installment_years'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="mb-3">
                                <label for="customer_id" class="form-label">Select Customer *</label>
                                <select class="form-control <?php $__errorArgs = ['customer_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="customer_id" name="customer_id" required>
                                    <option value="">Select a customer</option>
                                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($customer->id); ?>" <?php echo e(old('customer_id') == $customer->id ? 'selected' : ''); ?>>
                                            <?php echo e($customer->name); ?> - <?php echo e($customer->phone); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['customer_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <div class="mt-2">
                                    <a href="<?php echo e(route('customers.create')); ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="fas fa-plus"></i> Add New Customer
                                    </a>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="description" class="form-label">Description</label>
                                <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                          id="description" name="description" rows="3"
                                          placeholder="Enter property description"><?php echo e(old('description')); ?></textarea>
                                <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Calculation Preview -->
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title">Installment Preview</h6>
                                    <div class="row">
                                        <div class="col-6">
                                            <small class="text-muted">Installment Amount:</small>
                                            <p class="mb-1"><strong id="preview_installment_amount">Rs. 0.00</strong></p>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-muted">Total Installments:</small>
                                            <p class="mb-1"><strong id="preview_total_installments">0</strong></p>
                                        </div>
                                        <div class="col-12 mt-2">
                                            <small class="text-muted">Payment After Down:</small>
                                            <p class="mb-0"><strong id="preview_remaining_amount">Rs. 0.00</strong></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle me-2"></i>
                                <strong>Note:</strong> After creating the property, the system will automatically generate monthly installments for the selected customer.
                            </div>
                        </div>
                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i> Create Property & Generate Installments
                        </button>
                        <a href="<?php echo e(route('properties.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        // Calculate installment preview
        function calculatePreview() {
            const totalPrice = parseFloat($('#total_price').val()) || 0;
            const downPayment = parseFloat($('#down_payment').val()) || 0;
            const years = parseInt($('#installment_years').val()) || 0;

            if (years > 0 && totalPrice > 0) {
                const remainingAmount = totalPrice - downPayment;
                const monthlyInstallment = remainingAmount / (years * 12);
                const totalInstallments = years * 12;

                $('#preview_installment_amount').text('Rs. ' + monthlyInstallment.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,'));
                $('#preview_total_installments').text(totalInstallments);
                $('#preview_remaining_amount').text('Rs. ' + remainingAmount.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,'));
            }
        }

        // Trigger calculation on input change
        $('#total_price, #down_payment, #installment_years').on('input change', calculatePreview);

        // Form validation
        $('#propertyForm').validate({
            rules: {
                name: 'required',
                location: 'required',
                total_price: {
                    required: true,
                    min: 100000
                },
                down_payment: {
                    required: true,
                    min: 0
                },
                installment_years: {
                    required: true,
                    min: 1
                },
                customer_id: 'required'
            },
            messages: {
                name: 'Please enter property name',
                location: 'Please enter property location',
                total_price: {
                    required: 'Please enter total price',
                    min: 'Minimum price should be Rs. 100,000'
                },
                down_payment: {
                    required: 'Please enter down payment',
                    min: 'Down payment cannot be negative'
                },
                installment_years: {
                    required: 'Please select installment period',
                    min: 'Minimum period is 1 year'
                },
                customer_id: 'Please select a customer'
            },
            errorElement: 'div',
            errorClass: 'invalid-feedback',
            highlight: function(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element) {
                $(element).removeClass('is-invalid');
            }
        });

        // Initial calculation
        calculatePreview();
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\property-system\resources\views/properties/create.blade.php ENDPATH**/ ?>