<?php $__env->startSection('title', 'Record New Payment'); ?>
<?php $__env->startSection('page-title', 'Record New Payment'); ?>

<?php $__env->startSection('content'); ?>
<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Payment Information</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="<?php echo e(route('payments.store')); ?>" id="paymentForm">
                    <?php echo csrf_field(); ?>

                    <div class="row">
                        <!-- Customer Selection -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="customer_id" class="form-label">Customer *</label>
                                <select class="form-control <?php $__errorArgs = ['customer_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="customer_id" name="customer_id" required
                                        onchange="loadCustomerInstallments(this.value)">
                                    <option value="">Select a customer</option>
                                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($customer->id); ?>"
                                                <?php echo e(old('customer_id', $customer->id == ($customer ?? null)?->id ? $customer->id : '') == $customer->id ? 'selected' : ''); ?>>
                                            <?php echo e($customer->name); ?> - <?php echo e($customer->phone); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['customer_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Installment Selection -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="installment_id" class="form-label">Installment *</label>
                                <select class="form-control <?php $__errorArgs = ['installment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="installment_id" name="installment_id" required
                                        onchange="loadInstallmentDetails(this.value)">
                                    <option value="">Select an installment</option>
                                    <?php if(isset($installment) && $installment): ?>
                                        <option value="<?php echo e($installment->id); ?>" selected>
                                            Property: <?php echo e($installment->property->name); ?> |
                                            Installment #<?php echo e($installment->installment_number); ?> |
                                            Due: <?php echo e($installment->due_date->format('d/m/Y')); ?>

                                        </option>
                                    <?php endif; ?>
                                </select>
                                <?php $__errorArgs = ['installment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <!-- Installment Details -->
                    <div id="installmentDetails" class="card bg-light mb-4" style="display: none;">
                        <div class="card-body">
                            <h6 class="card-title">Installment Details</h6>
                            <div class="row">
                                <div class="col-md-4">
                                    <small class="text-muted">Property</small>
                                    <p class="mb-1"><strong id="propertyName">-</strong></p>
                                </div>
                                <div class="col-md-4">
                                    <small class="text-muted">Total Amount</small>
                                    <p class="mb-1"><strong id="installmentAmount">Rs. 0.00</strong></p>
                                </div>
                                <div class="col-md-4">
                                    <small class="text-muted">Paid Amount</small>
                                    <p class="mb-1"><strong id="paidAmount">Rs. 0.00</strong></p>
                                </div>
                                <div class="col-md-4">
                                    <small class="text-muted">Remaining Amount</small>
                                    <p class="mb-1"><strong id="remainingAmount" class="text-warning">Rs. 0.00</strong></p>
                                </div>
                                <div class="col-md-4">
                                    <small class="text-muted">Due Date</small>
                                    <p class="mb-1"><strong id="dueDate">-</strong></p>
                                </div>
                                <div class="col-md-4">
                                    <small class="text-muted">Status</small>
                                    <p class="mb-1">
                                        <span id="installmentStatus" class="badge bg-secondary">-</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <!-- Payment Details -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="amount" class="form-label">Payment Amount (PKR) *</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rs.</span>
                                    <input type="number" step="0.01" class="form-control <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           id="amount" name="amount" value="<?php echo e(old('amount', isset($installment) ? $installment->remaining_amount : '')); ?>"
                                           placeholder="Enter payment amount" required min="0">
                                </div>
                                <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="mb-3">
                                <label for="payment_date" class="form-label">Payment Date *</label>
                                <input type="date" class="form-control <?php $__errorArgs = ['payment_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       id="payment_date" name="payment_date"
                                       value="<?php echo e(old('payment_date', date('Y-m-d'))); ?>" required>
                                <?php $__errorArgs = ['payment_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="payment_method" class="form-label">Payment Method *</label>
                                <select class="form-control <?php $__errorArgs = ['payment_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="payment_method" name="payment_method" required>
                                    <option value="">Select method</option>
                                    <option value="cash" <?php echo e(old('payment_method') == 'cash' ? 'selected' : ''); ?>>Cash</option>
                                    <option value="bank_transfer" <?php echo e(old('payment_method') == 'bank_transfer' ? 'selected' : ''); ?>>Bank Transfer</option>
                                    <option value="cheque" <?php echo e(old('payment_method') == 'cheque' ? 'selected' : ''); ?>>Cheque</option>
                                    <option value="online" <?php echo e(old('payment_method') == 'online' ? 'selected' : ''); ?>>Online</option>
                                </select>
                                <?php $__errorArgs = ['payment_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="mb-3">
                                <label for="reference_number" class="form-label">Reference Number</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['reference_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       id="reference_number" name="reference_number"
                                       value="<?php echo e(old('reference_number')); ?>"
                                       placeholder="Enter reference/transaction number">
                                <div class="form-text">Required for bank transfer, cheque, and online payments</div>
                                <?php $__errorArgs = ['reference_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="status" class="form-label">Payment Status *</label>
                                <select class="form-control <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="status" name="status" required>
                                    <option value="pending" <?php echo e(old('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                                    <option value="completed" <?php echo e(old('status') == 'completed' ? 'selected' : ''); ?>>Completed</option>
                                    <option value="failed" <?php echo e(old('status') == 'failed' ? 'selected' : ''); ?>>Failed</option>
                                </select>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="remarks" class="form-label">Remarks</label>
                        <textarea class="form-control <?php $__errorArgs = ['remarks'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                  id="remarks" name="remarks" rows="3"
                                  placeholder="Enter any remarks about this payment"><?php echo e(old('remarks')); ?></textarea>
                        <?php $__errorArgs = ['remarks'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>Note:</strong> After recording the payment, the installment status will be updated automatically based on the paid amount.
                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i> Record Payment
                        </button>
                        <button type="button" class="btn btn-outline-primary" onclick="saveAndAddAnother()">
                            <i class="fas fa-plus-circle me-2"></i> Save & Add Another
                        </button>
                        <a href="<?php echo e(route('payments.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        // Initialize with customer if provided
        <?php if(isset($customer) && $customer): ?>
            $('#customer_id').val('<?php echo e($customer->id); ?>').trigger('change');
        <?php endif; ?>

        // Initialize with installment if provided
        <?php if(isset($installment) && $installment): ?>
            loadInstallmentDetails(<?php echo e($installment->id); ?>);
        <?php endif; ?>

        // Load customer installments
        function loadCustomerInstallments(customerId) {
            if (!customerId) {
                $('#installment_id').html('<option value="">Select an installment</option>');
                return;
            }

            $('#installment_id').html('<option value="">Loading installments...</option>');

            fetch(`/api/customers/${customerId}/installments`)
                .then(response => response.json())
                .then(data => {
                    if (data.length === 0) {
                        $('#installment_id').html('<option value="">No installments found</option>');
                        return;
                    }

                    let options = '<option value="">Select an installment</option>';
                    data.forEach(installment => {
                        options += `<option value="${installment.id}">
                            Property: ${installment.property_name} |
                            Installment #${installment.installment_number} |
                            Due: ${installment.due_date} |
                            Remaining: Rs. ${parseFloat(installment.remaining_amount).toFixed(2)}
                        </option>`;
                    });

                    $('#installment_id').html(options);
                })
                .catch(error => {
                    console.error('Error:', error);
                    $('#installment_id').html('<option value="">Error loading installments</option>');
                });
        }

        // Load installment details
        function loadInstallmentDetails(installmentId) {
            if (!installmentId) {
                $('#installmentDetails').hide();
                return;
            }

            fetch(`/api/installments/${installmentId}`)
                .then(response => response.json())
                .then(data => {
                    if (data.error) {
                        alert(data.error);
                        return;
                    }

                    // Update installment details
                    $('#propertyName').text(data.property.name);
                    $('#installmentAmount').text('Rs. ' + parseFloat(data.amount).toFixed(2));
                    $('#paidAmount').text('Rs. ' + parseFloat(data.paid_amount).toFixed(2));
                    $('#remainingAmount').text('Rs. ' + parseFloat(data.remaining_amount).toFixed(2));
                    $('#dueDate').text(data.due_date);

                    // Update status badge
                    const statusColors = {
                        'paid': 'success',
                        'pending': 'warning',
                        'overdue': 'danger',
                        'partial': 'info'
                    };
                    $('#installmentStatus').removeClass().addClass('badge bg-' + statusColors[data.status]);
                    $('#installmentStatus').text(data.status.charAt(0).toUpperCase() + data.status.slice(1));

                    // Set payment amount to remaining amount
                    $('#amount').val(parseFloat(data.remaining_amount).toFixed(2));

                    // Show details card
                    $('#installmentDetails').show();
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Error loading installment details');
                });
        }

        // Validate payment amount doesn't exceed remaining amount
        $('#amount').on('change', function() {
            const remainingAmount = parseFloat($('#remainingAmount').text().replace('Rs.', '')) || 0;
            const paymentAmount = parseFloat($(this).val()) || 0;

            if (paymentAmount > remainingAmount) {
                alert('Payment amount cannot exceed remaining amount: Rs. ' + remainingAmount.toFixed(2));
                $(this).val(remainingAmount.toFixed(2));
            }
        });

        // Validate reference number based on payment method
        $('#payment_method').on('change', function() {
            const method = $(this).val();
            const referenceField = $('#reference_number');

            if (method === 'cash') {
                referenceField.removeAttr('required');
            } else {
                referenceField.attr('required', 'required');
            }
        });

        // Form validation
        $('#paymentForm').validate({
            rules: {
                customer_id: 'required',
                installment_id: 'required',
                amount: {
                    required: true,
                    min: 1,
                    max: function() {
                        const remaining = parseFloat($('#remainingAmount').text().replace('Rs.', '')) || 0;
                        return remaining;
                    }
                },
                payment_date: 'required',
                payment_method: 'required',
                reference_number: {
                    required: function() {
                        const method = $('#payment_method').val();
                        return method !== 'cash' && method !== '';
                    }
                },
                status: 'required'
            },
            messages: {
                customer_id: 'Please select a customer',
                installment_id: 'Please select an installment',
                amount: {
                    required: 'Please enter payment amount',
                    min: 'Amount must be at least Rs. 1',
                    max: 'Amount cannot exceed remaining amount'
                },
                payment_date: 'Please select payment date',
                payment_method: 'Please select payment method',
                reference_number: 'Reference number is required for this payment method',
                status: 'Please select payment status'
            },
            errorElement: 'div',
            errorClass: 'invalid-feedback',
            highlight: function(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element) {
                $(element).removeClass('is-invalid');
            }
        });
    });

    function saveAndAddAnother() {
        $('#paymentForm').append('<input type="hidden" name="add_another" value="1">');
        $('#paymentForm').submit();
    }
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\property-system\resources\views/payments/create.blade.php ENDPATH**/ ?>