<?php $__env->startSection('title', 'Properties'); ?>
<?php $__env->startSection('page-title', 'Properties Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Properties</h5>
        <a href="<?php echo e(route('properties.create')); ?>" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i> Add New Property
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Property Name</th>
                        <th>Location</th>
                        <th>Total Price</th>
                        <th>Installments</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td>
                            <strong><?php echo e($property->name); ?></strong>
                            <div class="small text-muted"><?php echo e($property->description); ?></div>
                        </td>
                        <td><?php echo e($property->location); ?></td>
                        <td>
                            <strong>Rs. <?php echo e(number_format($property->total_price, 2)); ?></strong>
                            <div class="small text-muted">
                                Down: Rs. <?php echo e(number_format($property->down_payment, 2)); ?>

                            </div>
                        </td>
                        <td>
                            <div class="progress" style="height: 20px;">
                                <?php
                                    $progress = $property->installments_count ?
                                        ($property->installments->where('status', 'paid')->count() / $property->total_installments) * 100 : 0;
                                ?>
                                <div class="progress-bar bg-success" role="progressbar"
                                     style="width: <?php echo e($progress); ?>%">
                                    <?php echo e(round($progress)); ?>%
                                </div>
                            </div>
                            <div class="small text-muted mt-1">
                                <?php echo e($property->installments->where('status', 'paid')->count()); ?>/<?php echo e($property->total_installments); ?> paid
                            </div>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($property->status == 'active' ? 'success' : ($property->status == 'completed' ? 'primary' : 'danger')); ?>">
                                <?php echo e(ucfirst($property->status)); ?>

                            </span>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="<?php echo e(route('properties.show', $property)); ?>" class="btn btn-sm btn-info">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="<?php echo e(route('properties.edit', $property)); ?>" class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="<?php echo e(route('properties.destroy', $property)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <div class="d-flex justify-content-center">
            <?php echo e($properties->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\property-system\resources\views/properties/index.blade.php ENDPATH**/ ?>